<?php

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
namespace FluentSmtpLib\Google\Service\Gmail;

class ListHistoryResponse extends \FluentSmtpLib\Google\Collection
{
    protected $collection_key = 'history';
    protected $historyType = History::class;
    protected $historyDataType = 'array';
    /**
     * @var string
     */
    public $historyId;
    /**
     * @var string
     */
    public $nextPageToken;
    /**
     * @param History[]
     */
    public function setHistory($history)
    {
        $this->history = $history;
    }
    /**
     * @return History[]
     */
    public function getHistory()
    {
        return $this->history;
    }
    /**
     * @param string
     */
    public function setHistoryId($historyId)
    {
        $this->historyId = $historyId;
    }
    /**
     * @return string
     */
    public function getHistoryId()
    {
        return $this->historyId;
    }
    /**
     * @param string
     */
    public function setNextPageToken($nextPageToken)
    {
        $this->nextPageToken = $nextPageToken;
    }
    /**
     * @return string
     */
    public function getNextPageToken()
    {
        return $this->nextPageToken;
    }
}
// Adding a class alias for backwards compatibility with the previous class name.
\class_alias(ListHistoryResponse::class, 'FluentSmtpLib\\Google_Service_Gmail_ListHistoryResponse');
